© 2026 Navorix LTD. All rights reserved.

# SaaS OS — Free Edition (v1.0)

**Contract-Driven UI Foundation**

SaaS OS Free Edition is a structured UI foundation designed to introduce a contract-driven approach to building SaaS interfaces.

It connects design tokens, component contracts, and implementation rules — without UI guesswork.

---

## What This Is

SaaS OS Free Edition provides the core building blocks of the system:

- Semantic, code-ready design tokens
- Button contract
- Input contract
- Basic Cursor execution rules
- Figma reference file (view-only)

This edition is designed for:

- Evaluation
- Learning the contract-driven model
- Building simple, deterministic UI structures

---

## Package Contents

```
SaaS OS v1.0/
├── adapters/
├── docs/
├── figma/
├── quick-reference/
├── tokens-export/
└── README.md
```

Refer to `/quick-reference/getting-started.md` to begin.

---

## How to Use

1. Review contracts in `/docs/engineering/contracts`.
2. Import `/tokens-export/tokens.css` globally in your project.
3. Implement components strictly according to the contracts.
4. When using Cursor:
   - Load `/adapters/cursor/system-rules.md`
   - Reference the relevant contract explicitly
   - Keep prompts narrow and component-scoped

If behaviour is not defined in a contract, it must not be implemented.

---

## Scope (Free Edition)

This edition includes foundational tokens and core contracts.

Advanced component contracts, reference flows, architectural enforcement, and extended AI orchestration are available in SaaS OS Pro.

---

## Licensing

SaaS OS Free Edition is provided for evaluation and individual use.

- Redistribution is not permitted.
- Resale is not permitted.
- Public reposting is not permitted.

For commercial or enterprise usage, refer to SaaS OS Pro.

---

## Philosophy

SaaS OS is built on three principles:

1. Determinism over convenience
2. Explicit contracts over implicit behaviour
3. Code must conform to contracts

Contracts define meaning.
Code implements meaning.